/*
 * Decompiled with CFR 0.152.
 */
package team.unnamed.mocha.runtime;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.NotFoundException;
import javassist.bytecode.Bytecode;
import javassist.bytecode.Descriptor;
import org.jetbrains.annotations.NotNull;
import team.unnamed.mocha.parser.ast.AccessExpression;
import team.unnamed.mocha.parser.ast.BinaryExpression;
import team.unnamed.mocha.parser.ast.CallExpression;
import team.unnamed.mocha.parser.ast.Expression;
import team.unnamed.mocha.parser.ast.ExpressionVisitor;
import team.unnamed.mocha.parser.ast.FloatExpression;
import team.unnamed.mocha.parser.ast.IdentifierExpression;
import team.unnamed.mocha.parser.ast.StringExpression;
import team.unnamed.mocha.parser.ast.TernaryConditionalExpression;
import team.unnamed.mocha.parser.ast.UnaryExpression;
import team.unnamed.mocha.runtime.CompileVisitResult;
import team.unnamed.mocha.runtime.FunctionCompileState;
import team.unnamed.mocha.runtime.Scope;
import team.unnamed.mocha.runtime.binding.Entity;
import team.unnamed.mocha.runtime.binding.JavaFieldBinding;
import team.unnamed.mocha.runtime.binding.JavaFunction;
import team.unnamed.mocha.runtime.binding.JavaObjectBinding;
import team.unnamed.mocha.runtime.value.Function;
import team.unnamed.mocha.runtime.value.NumberValue;
import team.unnamed.mocha.runtime.value.ObjectValue;
import team.unnamed.mocha.runtime.value.Value;
import team.unnamed.mocha.util.CaseInsensitiveStringHashMap;
import team.unnamed.mocha.util.JavassistUtil;

final class MolangCompilingVisitor
implements ExpressionVisitor<CompileVisitResult> {
    private static final int[] OPCODES_BY_BINARY_EXPRESSION_OP = new int[]{-1, -1, 155, 158, 157, 156, 98, 102, 106, 110, -1, -1, -1, -1, 153, 154};
    private final ClassPool classPool;
    private final Bytecode bytecode;
    private final Method method;
    private final FunctionCompileState functionCompileState;
    private final Map<String, Object> requirements;
    private final Map<String, Integer> argumentParameterIndexes;
    private final Map<String, Integer> localsByName = new CaseInsensitiveStringHashMap<Integer>();
    private final CtClass stringCtType;
    private final CtClass methodReturnType;
    private CtClass expectedType;

    MolangCompilingVisitor(@NotNull FunctionCompileState compileState) {
        this.functionCompileState = compileState;
        this.classPool = compileState.classPool();
        this.bytecode = compileState.bytecode();
        this.method = compileState.method();
        this.requirements = compileState.requirements();
        this.argumentParameterIndexes = compileState.argumentParameterIndexes();
        try {
            this.stringCtType = this.classPool.get(String.class.getName());
            this.methodReturnType = this.classPool.get(this.method.getReturnType().getName());
        }
        catch (NotFoundException e) {
            throw new IllegalStateException("Couldn't find CtClass for standard classes", e);
        }
        this.expectedType = this.methodReturnType;
    }

    @Override
    public CompileVisitResult visitBinary(@NotNull BinaryExpression expression) {
        Expression objectExpr;
        Expression left;
        BinaryExpression.Op op = expression.op();
        if (op == BinaryExpression.Op.ASSIGN && (left = expression.left()) instanceof AccessExpression && (objectExpr = ((AccessExpression)left).object()) instanceof IdentifierExpression) {
            String name = ((IdentifierExpression)objectExpr).name();
            String property = ((AccessExpression)left).property();
            if (name.equals("temp") || name.equals("t")) {
                CompileVisitResult result = expression.right().visit(this);
                int localIndex = this.localsByName.computeIfAbsent(property, k -> {
                    int index = this.functionCompileState.maxLocals();
                    if (result.lastPushedType() == CtClass.doubleType || result.lastPushedType() == CtClass.longType) {
                        this.functionCompileState.maxLocals(index + 2);
                    } else {
                        this.functionCompileState.maxLocals(index + 1);
                    }
                    return index;
                });
                this.bytecode.addFstore(localIndex);
                return null;
            }
        }
        CtClass currentExpectedType = this.expectedType;
        switch (op) {
            case AND: {
                int const_1;
                int const_0;
                if (this.expectedType == CtClass.doubleType) {
                    const_0 = 14;
                    const_1 = 15;
                } else if (this.expectedType == CtClass.floatType) {
                    const_0 = 11;
                    const_1 = 12;
                } else if (this.expectedType == CtClass.longType) {
                    const_0 = 9;
                    const_1 = 10;
                } else {
                    const_0 = 3;
                    const_1 = 4;
                }
                this.expectedType = CtClass.booleanType;
                expression.left().visit(this);
                this.bytecode.addOpcode(153);
                int indexPc = this.bytecode.currentPc();
                this.bytecode.addGap(2);
                expression.right().visit(this);
                this.bytecode.addOpcode(153);
                this.bytecode.addIndex(7);
                this.bytecode.addOpcode(const_1);
                this.bytecode.addOpcode(167);
                this.bytecode.addIndex(4);
                this.bytecode.write16bit(indexPc, this.bytecode.currentPc() - indexPc + 1);
                this.bytecode.addOpcode(const_0);
                this.expectedType = currentExpectedType;
                return new CompileVisitResult(currentExpectedType);
            }
            case OR: {
                int const_1;
                int const_0;
                if (this.expectedType == CtClass.doubleType) {
                    const_0 = 14;
                    const_1 = 15;
                } else if (this.expectedType == CtClass.floatType) {
                    const_0 = 11;
                    const_1 = 12;
                } else if (this.expectedType == CtClass.longType) {
                    const_0 = 9;
                    const_1 = 10;
                } else {
                    const_0 = 3;
                    const_1 = 4;
                }
                this.expectedType = CtClass.booleanType;
                expression.left().visit(this);
                this.bytecode.addOpcode(154);
                int indexPc = this.bytecode.currentPc();
                this.bytecode.addGap(2);
                expression.right().visit(this);
                this.bytecode.addOpcode(153);
                this.bytecode.addIndex(7);
                this.bytecode.write16bit(indexPc, this.bytecode.currentPc() - indexPc + 1);
                this.bytecode.addOpcode(const_1);
                this.bytecode.addOpcode(167);
                this.bytecode.addIndex(4);
                this.bytecode.addOpcode(const_0);
                this.expectedType = currentExpectedType;
                return new CompileVisitResult(currentExpectedType);
            }
            case EQ: 
            case NEQ: 
            case LT: 
            case LTE: 
            case GT: 
            case GTE: {
                int const_1;
                int const_0;
                this.expectedType = CtClass.floatType;
                expression.left().visit(this);
                expression.right().visit(this);
                this.expectedType = currentExpectedType;
                if (this.expectedType == CtClass.doubleType) {
                    const_0 = 14;
                    const_1 = 15;
                } else if (this.expectedType == CtClass.floatType) {
                    const_0 = 11;
                    const_1 = 12;
                } else if (this.expectedType == CtClass.longType) {
                    const_0 = 9;
                    const_1 = 10;
                } else {
                    const_0 = 3;
                    const_1 = 4;
                }
                this.bytecode.addOpcode(149);
                this.bytecode.addOpcode(OPCODES_BY_BINARY_EXPRESSION_OP[op.ordinal()]);
                this.bytecode.addIndex(7);
                this.bytecode.addOpcode(const_0);
                this.bytecode.addOpcode(167);
                this.bytecode.addIndex(4);
                this.bytecode.addOpcode(const_1);
                return new CompileVisitResult(this.expectedType == null ? CtClass.booleanType : this.expectedType);
            }
            case ADD: 
            case SUB: 
            case MUL: 
            case DIV: {
                this.expectedType = CtClass.floatType;
                expression.left().visit(this);
                expression.right().visit(this);
                this.expectedType = currentExpectedType;
                this.bytecode.addOpcode(OPCODES_BY_BINARY_EXPRESSION_OP[op.ordinal()]);
                return new CompileVisitResult(CtClass.floatType);
            }
        }
        return null;
    }

    public void endVisit() {
        this.bytecode.addReturn(this.methodReturnType);
    }

    @Override
    @NotNull
    public CompileVisitResult visitFloat(@NotNull FloatExpression expression) {
        float value = expression.value();
        if (this.expectedType == CtClass.voidType) {
            return new CompileVisitResult(CtClass.voidType);
        }
        if (this.expectedType == null || this.expectedType == CtClass.floatType) {
            this.bytecode.addFconst(value);
            return new CompileVisitResult(CtClass.floatType);
        }
        if (this.expectedType == CtClass.booleanType) {
            if ((double)value != 0.0) {
                this.bytecode.addOpcode(4);
            } else {
                this.bytecode.addOpcode(3);
            }
            return new CompileVisitResult(CtClass.booleanType);
        }
        if (this.expectedType == CtClass.intType) {
            this.bytecode.addLdc((int)value);
            return new CompileVisitResult(CtClass.intType);
        }
        if (this.expectedType == CtClass.longType) {
            this.bytecode.addLdc2w((long)value);
            return new CompileVisitResult(CtClass.longType);
        }
        System.err.println("[warning] expected type " + String.valueOf(this.expectedType) + " has no possible cast from float (" + String.valueOf(expression) + ")");
        this.bytecode.addConstZero(this.expectedType);
        return new CompileVisitResult(this.expectedType);
    }

    @Override
    @NotNull
    public CompileVisitResult visitString(@NotNull StringExpression expression) {
        if (this.expectedType == CtClass.voidType) {
            return new CompileVisitResult(CtClass.voidType);
        }
        if (this.expectedType == null || this.expectedType == this.stringCtType) {
            this.bytecode.addLdc(expression.value());
            return new CompileVisitResult(this.stringCtType);
        }
        this.bytecode.addConstZero(this.expectedType);
        return new CompileVisitResult(this.expectedType);
    }

    @Override
    @NotNull
    public CompileVisitResult visitUnary(@NotNull UnaryExpression expression) {
        switch (expression.op()) {
            case RETURN: {
                this.expectedType = this.methodReturnType;
                expression.expression().visit(this);
                this.expectedType = null;
                this.bytecode.addReturn(this.methodReturnType);
                return new CompileVisitResult(this.methodReturnType, true);
            }
            case LOGICAL_NEGATION: {
                int const_0;
                int const_1;
                if (this.expectedType == CtClass.voidType) {
                    expression.expression().visit(this);
                    return new CompileVisitResult(CtClass.voidType);
                }
                CtClass currentExpectedType = this.expectedType;
                if (currentExpectedType != null && !currentExpectedType.isPrimitive()) {
                    this.expectedType = CtClass.voidType;
                    expression.expression().visit(this);
                    this.expectedType = currentExpectedType;
                    this.bytecode.addConstZero(currentExpectedType);
                    return new CompileVisitResult(currentExpectedType);
                }
                this.expectedType = CtClass.booleanType;
                expression.expression().visit(this);
                this.expectedType = currentExpectedType;
                if (currentExpectedType == CtClass.booleanType) {
                    this.bytecode.addOpcode(154);
                    return new CompileVisitResult(CtClass.booleanType);
                }
                if (currentExpectedType == CtClass.doubleType) {
                    const_1 = 15;
                    const_0 = 14;
                } else if (currentExpectedType == CtClass.floatType) {
                    const_1 = 12;
                    const_0 = 11;
                } else if (currentExpectedType == CtClass.longType) {
                    const_1 = 10;
                    const_0 = 9;
                } else {
                    const_1 = 4;
                    const_0 = 3;
                }
                this.bytecode.addOpcode(154);
                this.bytecode.addIndex(7);
                this.bytecode.addOpcode(const_1);
                this.bytecode.addOpcode(167);
                this.bytecode.addIndex(4);
                this.bytecode.addOpcode(const_0);
                return new CompileVisitResult(currentExpectedType);
            }
            case ARITHMETICAL_NEGATION: {
                CompileVisitResult result = expression.expression().visit(this);
                if (result.is(CtClass.doubleType)) {
                    this.bytecode.addOpcode(119);
                    break;
                }
                if (result.is(CtClass.longType)) {
                    this.bytecode.addOpcode(117);
                    break;
                }
                if (result.is(CtClass.floatType)) {
                    this.bytecode.addOpcode(118);
                    break;
                }
                if (result.is(CtClass.intType)) {
                    this.bytecode.addOpcode(116);
                    break;
                }
                if (result.is(CtClass.booleanType)) {
                    this.bytecode.addOpcode(4);
                    this.bytecode.addOpcode(130);
                    break;
                }
                throw new IllegalStateException("Unsupported type for negation: " + String.valueOf(result));
            }
            default: {
                throw new UnsupportedOperationException("Unsupported unary operator: " + String.valueOf((Object)expression.op()));
            }
        }
        return null;
    }

    @Override
    @NotNull
    public CompileVisitResult visitTernaryConditional(@NotNull TernaryConditionalExpression expression) {
        Expression trueExpr = expression.trueExpression();
        Expression falseExpr = expression.falseExpression();
        CtClass currentExpectedType = this.expectedType;
        this.expectedType = CtClass.booleanType;
        CompileVisitResult conditionRes = expression.condition().visit(this);
        this.expectedType = currentExpectedType;
        if (conditionRes != null && conditionRes.lastPushedType() != null && !conditionRes.is(CtClass.booleanType) && !conditionRes.is(CtClass.intType)) {
            this.bytecode.addConstZero(conditionRes.lastPushedType());
            if (conditionRes.is(CtClass.doubleType)) {
                this.bytecode.addOpcode(151);
            } else if (conditionRes.is(CtClass.floatType)) {
                this.bytecode.addOpcode(149);
            } else if (conditionRes.is(CtClass.longType)) {
                this.bytecode.addOpcode(148);
            } else {
                throw new IllegalStateException("Unsupported type for comparison: " + String.valueOf(conditionRes));
            }
        }
        this.bytecode.addOpcode(153);
        int indexPc = this.bytecode.currentPc();
        this.bytecode.addGap(2);
        trueExpr.visit(this);
        this.bytecode.addOpcode(167);
        int indexPc2 = this.bytecode.currentPc();
        this.bytecode.addGap(2);
        this.bytecode.write16bit(indexPc, this.bytecode.currentPc() - indexPc + 1);
        falseExpr.visit(this);
        this.bytecode.write16bit(indexPc2, this.bytecode.currentPc() - indexPc2 + 1);
        return new CompileVisitResult(currentExpectedType);
    }

    @Override
    public CompileVisitResult visitIdentifier(@NotNull IdentifierExpression expression) {
        CtClass parameterCtType;
        String name = expression.name();
        Integer paramIndex = this.argumentParameterIndexes.get(name);
        if (paramIndex == null) {
            throw new IllegalStateException("Unknown variable: " + name);
        }
        Parameter[] parameters = this.method.getParameters();
        Parameter parameter = parameters[paramIndex];
        int loadIndex = 1;
        for (int i = 0; i < paramIndex; ++i) {
            Parameter param = parameters[i];
            Class<?> paramType = param.getType();
            if (paramType.equals(Double.TYPE) || paramType.equals(Long.TYPE)) {
                loadIndex += 2;
                continue;
            }
            ++loadIndex;
        }
        try {
            parameterCtType = this.classPool.get(parameter.getType().getName());
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
        this.bytecode.addLoad(loadIndex, parameterCtType);
        if (this.expectedType == null) {
            return new CompileVisitResult(parameterCtType);
        }
        JavassistUtil.addCast(this.bytecode, parameterCtType, this.expectedType);
        return new CompileVisitResult(this.expectedType);
    }

    @Override
    public CompileVisitResult visitAccess(@NotNull AccessExpression expression) {
        ObjectValue actualObjectValue;
        String name;
        Expression objectExpr = expression.object();
        String property = expression.property();
        if (objectExpr instanceof IdentifierExpression && ((name = ((IdentifierExpression)objectExpr).name()).equals("temp") || name.equals("t"))) {
            Integer localIndex = this.localsByName.get(property);
            if (localIndex == null) {
                this.bytecode.addConstZero(CtClass.floatType);
            } else {
                this.bytecode.addFload(localIndex.intValue());
            }
            return new CompileVisitResult(CtClass.floatType);
        }
        final Scope scope = this.functionCompileState.scope();
        Value objectValue = objectExpr.visit(new ExpressionVisitor<Value>(){

            @Override
            @NotNull
            public Value visitIdentifier(@NotNull IdentifierExpression expression) {
                String name = expression.name();
                return scope.get(name);
            }

            @Override
            @NotNull
            public Value visitAccess(@NotNull AccessExpression expression) {
                Value object = expression.object().visit(this);
                if (object instanceof ObjectValue) {
                    return ((ObjectValue)object).get(expression.property());
                }
                return NumberValue.zero();
            }

            @Override
            @NotNull
            public Value visit(@NotNull Expression expression) {
                return NumberValue.zero();
            }
        });
        if (objectValue instanceof ObjectValue && (actualObjectValue = (ObjectValue)objectValue) instanceof JavaObjectBinding) {
            JavaFieldBinding javaFieldBinding = ((JavaObjectBinding)actualObjectValue).getField(property);
            if (javaFieldBinding == null) {
                this.bytecode.addOpcode(11);
            } else if (javaFieldBinding.constant()) {
                this.bytecode.addFconst(javaFieldBinding.get().getAsNumber());
            } else {
                Field field = javaFieldBinding.field();
                if (Modifier.isStatic(field.getModifiers())) {
                    try {
                        this.bytecode.addGetstatic(this.classPool.get(field.getDeclaringClass().getName()), field.getName(), Descriptor.of((String)field.getType().toString()));
                    }
                    catch (NotFoundException notFoundException) {
                        // empty catch block
                    }
                }
            }
        }
        return null;
    }

    @Override
    public CompileVisitResult visitCall(@NotNull CallExpression expression) {
        final Scope scope = this.functionCompileState.scope();
        Expression functionExpr = expression.function();
        Value functionValue = functionExpr.visit(new ExpressionVisitor<Value>(){

            @Override
            @NotNull
            public Value visitIdentifier(@NotNull IdentifierExpression expression) {
                String name = expression.name();
                return scope.get(name);
            }

            @Override
            @NotNull
            public Value visitAccess(@NotNull AccessExpression expression) {
                Value object = expression.object().visit(this);
                if (object instanceof ObjectValue) {
                    return ((ObjectValue)object).get(expression.property());
                }
                return NumberValue.zero();
            }

            @Override
            @NotNull
            public Value visit(@NotNull Expression expression) {
                return NumberValue.zero();
            }
        });
        if (!(functionValue instanceof Function)) {
            this.bytecode.addOpcode(11);
            return new CompileVisitResult(CtClass.floatType);
        }
        Function function = (Function)functionValue;
        if (function instanceof JavaFunction) {
            CtClass ctReturnType;
            CtClass nativeMethodDeclaringCtClass;
            JavaFunction javaFunction = (JavaFunction)function;
            Method nativeMethod = javaFunction.method();
            Parameter[] parameters = nativeMethod.getParameters();
            List<Expression> arguments = expression.arguments();
            CtClass[] ctParameters = new CtClass[parameters.length];
            for (int i = 0; i < parameters.length; ++i) {
                Parameter parameter = parameters[i];
                try {
                    ctParameters[i] = this.classPool.get(parameter.getType().getName());
                    continue;
                }
                catch (NotFoundException e) {
                    throw new IllegalStateException("Parameter type not found", e);
                }
            }
            Object object = javaFunction.object();
            Iterator<Expression> it = arguments.iterator();
            for (int i = 0; i < parameters.length; ++i) {
                Parameter parameter = parameters[i];
                if (parameter.isAnnotationPresent(Entity.class)) {
                    Object entity = this.functionCompileState.compiler().entity();
                    if (entity == null || !parameter.getType().isInstance(entity)) {
                        this.bytecode.addConstZero(ctParameters[i]);
                        continue;
                    }
                    this.requirements.put("__entity__", entity);
                    this.bytecode.addAload(0);
                    this.bytecode.addGetfield(this.functionCompileState.type(), "__entity__", Descriptor.of((CtClass)ctParameters[i]));
                    continue;
                }
                if (!it.hasNext()) {
                    this.bytecode.addConstZero(ctParameters[i]);
                    continue;
                }
                this.expectedType = ctParameters[i];
                it.next().visit(this);
            }
            try {
                nativeMethodDeclaringCtClass = this.classPool.get(nativeMethod.getDeclaringClass().getName());
                ctReturnType = this.classPool.get(nativeMethod.getReturnType().getName());
            }
            catch (NotFoundException e) {
                throw new IllegalStateException("Return type not found", e);
            }
            if (Modifier.isStatic(nativeMethod.getModifiers())) {
                this.bytecode.addInvokestatic(nativeMethodDeclaringCtClass, nativeMethod.getName(), ctReturnType, ctParameters);
            } else {
                CtClass requirementType;
                String fieldName = object.getClass().getSimpleName().toLowerCase() + Integer.toHexString(object.hashCode());
                this.requirements.put(fieldName, object);
                try {
                    requirementType = this.classPool.get(object.getClass().getName());
                }
                catch (NotFoundException e) {
                    throw new IllegalStateException("Field not found", e);
                }
                this.bytecode.addAload(0);
                this.bytecode.addGetfield(this.functionCompileState.type(), fieldName, Descriptor.of((CtClass)requirementType));
                this.bytecode.addInvokevirtual(nativeMethodDeclaringCtClass, nativeMethod.getName(), ctReturnType, ctParameters);
            }
            if (nativeMethod.getReturnType() == Void.TYPE) {
                if (this.expectedType != CtClass.voidType) {
                    this.bytecode.addConstZero(this.expectedType);
                }
            } else if (!nativeMethod.getReturnType().getName().equals(this.expectedType.getName())) {
                JavassistUtil.addCast(this.bytecode, ctReturnType, this.expectedType);
            }
        } else {
            throw new UnsupportedOperationException("Not supporting non-Java functions yet");
        }
        return null;
    }

    @Override
    public CompileVisitResult visit(@NotNull Expression expression) {
        throw new UnsupportedOperationException("Unsupported expression type: " + String.valueOf(expression));
    }
}

